
local M 
do

local busid = 0  -- I2C Bus ID. Always zero
local sda= 12     -- GPIO2 pin mapping is 4
local scl= 6     -- GPIO0 pin mapping is 3

local addr=0x20  -- the I2C address of our device

-- Seting up the I2C bus.
i2c.setup(busid,sda,scl,i2c.SLOW)

-- Read from the pcf8574
local function read_pcf8574()
     i2c.start(busid)
     i2c.address(busid, addr , i2c.RECEIVER)
     bdata = i2c.read(busid,1)  -- Reads one byte
     i2c.stop(busid)
     return bdata
end

-- Writes to the pcf8574
local function write_pcf8574(value)
     i2c.start(busid)
     i2c.address(busid, addr, i2c.TRANSMITTER)
     i2c.write(busid,value)
     i2c.stop(busid)
end


local function set_status()
local b={}

   if ListTime[3].data>OUT_STATUS.CO2[2] then  b[1]=0x2 
   elseif ListTime[3].data>OUT_STATUS.CO2[1] then  b[1]=0x1
   else b[1]=0x0 end;


   if ListTime[9].data>=OUT_STATUS.CH2O[2] then   b[2]=0x02
        elseif ListTime[9].data>=OUT_STATUS.CH2O[1] then   b[2]=0x01
        else b[2]=0x00 end;
   
   if ListTime[6].data>=OUT_STATUS.PM25[2] then   b[3]=0x2
        elseif ListTime[6].data>=OUT_STATUS.PM25[1] then   b[3]=0x1
        else b[3]=0x0 end;     

   if ListTime[7].data>=OUT_STATUS.PM10[2] then   b[4]=0x2
        elseif ListTime[7].data>=OUT_STATUS.PM10[1] then   b[4]=0x1
        else b[4]=0x0 end;          
     local dv=b[1]+b[2]*4+b[3]*16+b[4]*64;   
     if OUT_STATUS.INV>0 then dv=0xFF-dv; end;
    write_pcf8574(dv)
    print('OS',b[1],b[2],b[3],b[4])
     tmr.delay(20000)
    local result=read_pcf8574()
    print('OUT_STATUS',string.byte(result))
end;

M={read_pcf8574=read_pcf8574, write_pcf8574=write_pcf8574,set_status=set_status}
end
return M

-- Main program.
--[[
i2c.setup(busid,sda,scl,i2c.SLOW)

for i=1, 254 do 
    write_pcf8574( addr,  i )
    tmr.delay(20000)
    result=read_pcf8574(addr)
    print(string.byte(result))
    tmr.wdclr()
end

--]]
